module top (
    input clk,
    input rst,
    output reg red,
    output reg yellow,
    output reg green
);

localparam CLK_CYCLES_PER_SECOND = 27000000;

localparam
    S_RED = 2'b00,
    S_RED_YELLOW = 2'b01,
    S_GREEN = 2'b10,
    S_YELLOW = 2'b11;
reg [31:0] counter;
reg [31:0] wait_time;
reg [1:0] state, next_state;

function [31:0] get_wait_time;
    input [1:0] s;
    begin
        case (s)
            S_RED:         get_wait_time = 5 * CLK_CYCLES_PER_SECOND;
            S_RED_YELLOW:  get_wait_time = 1 * CLK_CYCLES_PER_SECOND;
            S_GREEN:       get_wait_time = 5 * CLK_CYCLES_PER_SECOND;
            S_YELLOW:      get_wait_time = 1 * CLK_CYCLES_PER_SECOND;
            default:       get_wait_time = 5 * CLK_CYCLES_PER_SECOND;
        endcase
    end
endfunction

    always @(posedge clk) begin
        if (~rst) begin
            state <= S_RED;
        end else
            state <= next_state;
        wait_time <= get_wait_time(next_state);
    end

    always @(posedge clk) begin
        if (~rst)
            counter <= 0;
        else if (counter < wait_time)
            counter <= counter + 1;
        else
            counter <= 0;
    end

    always @(*) begin
        next_state = state;
        if (counter >= wait_time)
            case (state)
                S_RED: next_state = S_RED_YELLOW;
                S_RED_YELLOW: next_state = S_GREEN;
                S_GREEN: next_state = S_YELLOW;
                S_YELLOW: next_state = S_RED;
                default: next_state = S_RED;
            endcase
    end

    always @(posedge clk) begin
        if (~rst) begin
            red <= 1'b0;
            yellow <= 1'b0;
            green <= 1'b0;
        end else begin
            red <= ~(state == S_RED || state == S_RED_YELLOW);
            yellow <= ~(state == S_RED_YELLOW || state == S_YELLOW);
            green <= ~(state == S_GREEN);
        end
    end
endmodule
