#!/bin/bash
set -eeuo pipefail

# your configuration constants
# generate key and secret on /ui/auth/user
OPNSENSE_URL="https://opnsense.yournetwork.lan"
OPNSENSE_KEY=""
OPNSENSE_SECRET=""
GPG_RECIPIENT=""
BACKUP_DESTINATION="./backups"

# general constants
API_PATH="/api/core/backup/download/this"
DATE_FORMAT="%Y_%m_%d_%H_%M"
DATE=$(date +"${DATE_FORMAT}")
BACKUP_FILENAME="${BACKUP_DESTINATION}/${DATE}.xml.gz.gpg"

curl -k -f -u "${OPNSENSE_KEY}:${OPNSENSE_SECRET}" "${OPNSENSE_URL}${API_PATH}" \
  | gzip -c - \
  | gpg -e -r ${GPG_RECIPIENT} > ${BACKUP_FILENAME}

echo "Written opnsense backup to ${BACKUP_FILENAME}"