import pandas as pd

from datetime import datetime, date, timedelta

BC_START_DATE = date(2025, 3, 6)
PRICE = 2988.00
FILENAME = "Transaktionen.csv"

TODAY = date.today()
BC_END_DATE = BC_START_DATE + timedelta(days=365)

df = pd.read_csv(
    FILENAME,
    converters={
        "Betrag": lambda x: float(x.replace(",", ".")),
        "Buchungsdatum": lambda x: datetime.strptime(x, "%d.%m.%Y").date()
    }
)

df = df[
    (df["Zahlungsempfänger"] == "Deutsche Bahn") &
    (df["Verwendungszweck"].str.contains("Fahrgastrechtsfall", case=False)) & 
    (df["Betrag"] == 10) & 
    (df["Buchungsdatum"] >= BC_START_DATE)
]

current_amount = df["Betrag"].sum()
max_amount = round(((BC_END_DATE - TODAY).days / 365) * PRICE * 0.25, 2)

print("{:.2f} € von {:.2f} € ({}%)".format(
    df["Betrag"].sum(),
    max_amount,
    round((current_amount / max_amount) * 100)
))
